import mido
import pigpio
from numpy import interp
#!/usr/bin/env python3
import pyfirmata
import time
pi1 = pigpio.pi()
port = mido.open_input('f_midi') # open USB port

class free:
    def __init__(self, PWM, delay, teir, runtimetwo, count, a):
        self.PWM = 20000
        self.delay = .38
        self.teir = 2000
        self.runtimetwo = 3.0
        self.count = 1
        self.a = 201

        self.DDS_REF 180000000
        self.BASE_FREQ 2000000

        self.POT_CS    5
        self.POT_SCK   6
        self.POT_SI    7

        self.DDS_CLOCK  8
        self.DDS_LOAD   9
        self.DDS_DATA   10
        self.DDS_RESET  11

        while True:
        try: #This filters out all non-note data
        for msg in port.iter_pending(): # if there is a message pending
        if(msg.type == 'note_on'): # if it is Note On message
        out = interp(msg.velocity, [0,127],[0,255]) #
        scale velocity from 0-127 to 0-255

        while True:
        try: #This filters out all non-note data
        for msg in port.iter_pending(): #if there is a message pending
        if msg.type == 'pitchwheel': #of type pitchwheel
        print("PITCH: ", msg.pitch)
        out = interp(msg.pitch, [-8192,8192],[0,255])
        pi1.set_PWM_dutycycle(2, out)
        pi1.set_PWM_dutycycle(3, out)
        pi1.set_PWM_dutycycle(4, out)
        if msg.type == 'control_change' and msg.control == 1:
        print("MOD: ", msg.value)
        except AttributeError as error:
        print("Error excepted")
        pass

        #cb = pi1.callback(buttPin,pigpio.RISING_EDGE, buttonDown)
        #cb2 = pi1.callback(buttPin,pigpio.FALLING_EDGE, buttonUp)

        if __name__ == '__main__':
            board = pyfirmata.Arduino('YOUR_PORT_HERE')
            print("Communication Successfully started")
    
            board.digital[DDS_RESET].write(1);
            board.digital[DDS_RESET].write(0);
  
            board.digital[self.DDS_CLOCK].write(1);
            board.digital[self.DDS_CLOCK].write(0);

            board.digital[self.DDS_LOAD].write(1);
            board.digital[self.DDS_LOAD].write(0);

    def sequence(self):
        for x in range(a):
            self.PWM += self.teir*self.delay
            self.sendFrequency(self.PWM)
            self.sendPotentiometer(int(4.0+x*15.0/200.0))
            print(self.PWM)
        self.PWM = 20000

    def tfr_byte(byte data)
        for (int i=0; i<8; i++, data>>=1):
            board.digital[self.DDS_DATA].write(data & 0x01)
            board.digital[self.DDS_CLOCK].write(1)
            board.digital[self.DDS_CLOCK].write(0)
            
    def pot_byte(byte data)
        for (int i=0; i<8; i++, data>>=1):
            board.digital[self.POT_SI].write(data & 0x01)
            board.digital[self.POT_SCK].write(1)
            board.digital[self.POT_SCK].write(0)

    def sendFrequency(double frequency) {
        board.digital[self.DDS_LOAD].write(0)
        int32_t freq = frequency * 4294967295/125000000;  // 125 MHz clock on 9850
        for (int b=0; b<4; b++, freq>>=8):
            tfr_byte(freq & 0xFF)
            tfr_byte(0x000)
            board.digital[self.DDS_LOAD].write(1)
            board.digital[self.DDS_LOAD].write(0)

    def sendPotentiometer(int scalevalue)
        board.digital[self.POT_CS].write(0)
        pot_byte(scalevalue & 0xFF)
        board.digital[self.POT_CS].write(1)

PWM = 20000
delay = .38
teir = 2000
runtimetwo = 3.0
count = 1
a = 31

print(a)

u = free(PWM, delay, teir, runtimetwo, count, a)
u.sequence()
